<?php
session_start();
if (!isset($_SESSION['admin'])) {
    header("location:login.php");
    exit();
}
include 'koneksi.php';

if (isset($_POST['simpan'])) {
    $id_siswa     = mysqli_real_escape_string($conn, $_POST['id_siswa']);
    $tgl_bayar    = mysqli_real_escape_string($conn, $_POST['tgl_bayar']);
    $periode      = mysqli_real_escape_string($conn, $_POST['periode']);
    $jumlah_bayar = mysqli_real_escape_string($conn, $_POST['jumlah_bayar']);
    $metode_bayar = mysqli_real_escape_string($conn, $_POST['metode_bayar']);
    $keterangan   = mysqli_real_escape_string($conn, $_POST['keterangan']);

    $query = "INSERT INTO pembayaran (id_siswa, tgl_bayar, periode, jumlah_bayar, metode_bayar, keterangan) 
              VALUES ('$id_siswa', '$tgl_bayar', '$periode', '$jumlah_bayar', '$metode_bayar', '$keterangan')";
    
    if (mysqli_query($conn, $query)) {
        echo "<script>alert('Pembayaran Berhasil Disimpan!'); window.location='index.php';</script>";
    } else {
        echo "<script>alert('Gagal: " . mysqli_error($conn) . "');</script>";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Transaksi Pembayaran - SPP Digital</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="bg-emerald-50 font-sans">

    <nav class="bg-emerald-600 p-4 text-white shadow-lg">
        <div class="container mx-auto flex justify-between items-center">
            <div class="flex items-center gap-2">
                <div class="bg-emerald-500 p-1.5 rounded text-white px-2">
                    <i class="fas fa-wallet"></i>
                </div>
                <h1 class="text-lg font-bold">SPP Digital</h1>
            </div>
            <div class="flex gap-4 text-xs font-bold">
                <a href="index.php" class="hover:bg-emerald-700 px-3 py-2 rounded-lg">Dashboard</a>
                <a href="bayar.php" class="bg-white text-emerald-600 px-3 py-2 rounded-lg">Pembayaran</a>
                <a href="logout.php" class="bg-orange-500 px-4 py-2 rounded-lg">Keluar</a>
            </div>
        </div>
    </nav>

    <main class="container mx-auto p-6 max-w-4xl">
        <div class="bg-white rounded-3xl shadow-xl overflow-hidden border border-gray-100">
            <div class="p-6 border-b bg-white text-emerald-600">
                <h2 class="text-xl font-bold"><i class="fas fa-wallet mr-2"></i> Form Transaksi Pembayaran</h2>
            </div>

            <form action="" method="POST" class="p-8 grid grid-cols-1 md:grid-cols-2 gap-6">
                <div class="md:col-span-2">
                    <label class="block text-xs font-bold text-gray-500 uppercase mb-2">Pilih Siswa</label>
                    <select name="id_siswa" required class="w-full border-2 border-gray-100 rounded-xl px-4 py-3 focus:border-emerald-500 outline-none">
                        <option value="">-- Pilih Nama Siswa --</option>
                        <?php
                        $siswa = mysqli_query($conn, "SELECT * FROM siswa");
                        while($s = mysqli_fetch_array($siswa)) {
                            echo "<option value='".$s['id']."'>".$s['nama_siswa']."</option>";
                        }
                        ?>
                    </select>
                </div>

                <div>
                    <label class="block text-xs font-bold text-gray-500 uppercase mb-2">Tanggal Pembayaran</label>
                    <input type="date" name="tgl_bayar" value="<?php echo date('Y-m-d'); ?>" required class="w-full border-2 border-gray-100 rounded-xl px-4 py-3 focus:border-emerald-500 outline-none">
                </div>
                <div>
                    <label class="block text-xs font-bold text-gray-500 uppercase mb-2">Periode (Bulan/Tahun)</label>
                    <input type="month" name="periode" required class="w-full border-2 border-gray-100 rounded-xl px-4 py-3 focus:border-emerald-500 outline-none">
                </div>

                <div>
                    <label class="block text-xs font-bold text-gray-500 uppercase mb-2">Jumlah (Rp)</label>
                    <input type="number" name="jumlah_bayar" required class="w-full border-2 border-gray-100 rounded-xl px-4 py-3 focus:border-emerald-500 outline-none">
                </div>
                <div>
                    <label class="block text-xs font-bold text-gray-500 uppercase mb-2">Metode Pembayaran</label>
                    <select name="metode_bayar" required class="w-full border-2 border-gray-100 rounded-xl px-4 py-3 focus:border-emerald-500 outline-none">
                        <option value="Tunai">Tunai</option>
                        <option value="Transfer">Transfer Bank</option>
                    </select>
                </div>

                <div class="md:col-span-2">
                    <label class="block text-xs font-bold text-gray-500 uppercase mb-2">Keterangan</label>
                    <textarea name="keterangan" class="w-full border-2 border-gray-100 rounded-xl px-4 py-3 focus:border-emerald-500 outline-none" placeholder="Opsional"></textarea>
                </div>

                <div class="md:col-span-2 flex gap-3 mt-4">
                    <button type="submit" name="simpan" class="bg-emerald-600 hover:bg-emerald-700 text-white px-8 py-4 rounded-2xl font-bold shadow-lg shadow-emerald-100 transition-all active:scale-95">Simpan Pembayaran</button>
                    <button type="reset" class="bg-gray-100 text-gray-400 px-8 py-4 rounded-2xl font-bold hover:bg-gray-200 transition">Reset</button>
                </div>
            </form>
        </div>
    </main>
</body>
</html>