<?php
include 'koneksi.php';

$id = isset($_GET['id']) ? $_GET['id'] : '';

if ($id == '') {
    die("ID Transaksi tidak ditemukan!");
}

$query = mysqli_query($conn, "SELECT pembayaran.*, siswa.nama_siswa, siswa.nis, siswa.kelas 
                              FROM pembayaran 
                              JOIN siswa ON pembayaran.id_siswa = siswa.id 
                              WHERE id_pembayaran = '$id'");
$data = mysqli_fetch_assoc($query);

if (!$data) {
    die("Data transaksi tidak ditemukan di database!");
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Kwitansi - <?php echo $data['nama_siswa']; ?></title>
    <style>
        body { font-family: 'Courier New', Courier, monospace; color: #333; background: #fff; }
        .invoice-box {
            max-width: 600px;
            margin: 20px auto;
            padding: 30px;
            border: 1px solid #d1fae5; /* Emerald 100 */
            border-radius: 10px;
        }
        .header { 
            text-align: center; 
            border-bottom: 2px solid #059669; /* Emerald 600 */
            padding-bottom: 10px; 
            margin-bottom: 20px; 
        }
        .header h1 { color: #059669; margin: 0; font-size: 24px; }
        .info table { width: 100%; line-height: 1.6; }
        .total-box { 
            background: #ecfdf5; /* Emerald 50 */
            padding: 15px; 
            border-radius: 5px; 
            text-align: center; 
            border: 1px solid #10b981; /* Emerald 500 */
            margin-top: 20px;
        }
        .footer { margin-top: 40px; text-align: right; font-size: 12px; }
        .btn-kembali {
            display: inline-block;
            margin-top: 20px;
            padding: 8px 15px;
            background: #059669;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            font-family: sans-serif;
        }
        @media print { 
            .no-print { display: none; } 
            .invoice-box { border: 1px solid #eee; box-shadow: none; margin: 0; }
        }
    </style>
</head>
<body onload="window.print()"> 

    <div class="invoice-box">
        <div class="header">
            <h1>ADMINISTRASI SEKOLAH</h1>
            <p style="margin:0;">Bukti Pembayaran Resmi</p>
        </div>

        <div class="info">
            <table>
                <tr>
                    <td width="150"><strong>No. Transaksi</strong></td>
                    <td>: #PAY-00<?php echo $data['id_pembayaran']; ?></td>
                </tr>
                <tr>
                    <td><strong>Tanggal</strong></td>
                    <td>: <?php echo date('d F Y', strtotime($data['tgl_bayar'])); ?></td>
                </tr>
                <tr><td colspan="2"><hr style="border: 0; border-top: 1px solid #d1fae5;"></td></tr>
                <tr>
                    <td><strong>NIS</strong></td>
                    <td>: <?php echo $data['nis']; ?></td>
                </tr>
                <tr>
                    <td><strong>Nama Siswa</strong></td>
                    <td>: <?php echo $data['nama_siswa']; ?></td>
                </tr>
                <tr>
                    <td><strong>Kelas</strong></td>
                    <td>: <?php echo $data['kelas']; ?></td>
                </tr>
                <tr>
                    <td><strong>Periode</strong></td>
                    <td>: <?php echo $data['periode']; ?></td>
                </tr>
                <tr>
                    <td><strong>Metode</strong></td>
                    <td>: <?php echo $data['metode_bayar']; ?></td>
                </tr>
            </table>
        </div>

        <div class="total-box">
            <h2 style="margin: 0; color: #059669;">TOTAL: Rp <?php echo number_format($data['jumlah_bayar'], 0, ',', '.'); ?></h2>
            <p style="margin: 5px 0 0 0; font-size: 12px; font-style: italic; color: #059669;">Status: LUNAS</p>
        </div>

        <div class="footer">
            <p>Dicetak pada: <?php echo date('d/m/Y H:i'); ?></p>
            <br><br><br>
            <p>____________________</p>
            <p>Petugas Administrasi</p>
        </div>
    </div>

    <center class="no-print">
        <a href="riwayat.php" class="btn-kembali"> Kembali ke Riwayat</a>
    </center>

</body>
</html>