<?php
session_start();
if (!isset($_SESSION['admin'])) {
    header("location:login.php");
    exit();
}
include 'koneksi.php';

$tgl_mulai  = isset($_GET['tgl_mulai']) ? $_GET['tgl_mulai'] : '';
$tgl_sampai = isset($_GET['tgl_sampai']) ? $_GET['tgl_sampai'] : '';
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Riwayat Laporan - SPP Digital</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="bg-emerald-50 font-sans">

    <nav class="bg-emerald-600 p-4 text-white shadow-lg no-print">
        <div class="container mx-auto flex justify-between items-center">
            <div class="flex items-center gap-2">
                <div class="bg-white p-1 rounded text-emerald-600 font-bold px-2 text-xs">
                    <i class="fas fa-wallet"></i> SPP
                </div>
                <h1 class="text-lg font-bold">SPP Digital</h1>
            </div>
            <div class="flex gap-4 text-xs font-bold">
                <a href="index.php" class="hover:bg-emerald-700 px-3 py-2 rounded-lg">Dashboard</a>
                <a href="siswa.php" class="hover:bg-emerald-700 px-3 py-2 rounded-lg">Siswa</a>
                <a href="riwayat.php" class="bg-white text-emerald-600 px-3 py-2 rounded-lg shadow-sm">Laporan</a>
                <a href="logout.php" class="bg-orange-500 px-4 py-2 rounded-lg">Keluar</a>
            </div>
        </div>
    </nav>

    <main class="container mx-auto p-6 max-w-6xl">
        <div class="bg-white p-6 rounded-3xl shadow-xl mb-8 border border-gray-100 no-print">
            <form action="" method="GET" class="flex flex-col md:flex-row gap-4 items-end">
                <div class="flex-1 w-full">
                    <label class="block text-[10px] font-bold text-gray-400 mb-1 ml-1">DARI TANGGAL</label>
                    <input type="date" name="tgl_mulai" value="<?php echo $tgl_mulai; ?>" class="w-full border-2 border-gray-100 rounded-xl px-4 py-2 outline-none focus:border-emerald-400">
                </div>
                <div class="flex-1 w-full">
                    <label class="block text-[10px] font-bold text-gray-400 mb-1 ml-1">SAMPAI TANGGAL</label>
                    <input type="date" name="tgl_sampai" value="<?php echo $tgl_sampai; ?>" class="w-full border-2 border-gray-100 rounded-xl px-4 py-2 outline-none focus:border-emerald-400">
                </div>
                <div class="flex gap-2 w-full md:w-auto">
                    <button type="submit" class="bg-emerald-600 text-white px-6 py-2.5 rounded-xl font-bold hover:bg-emerald-700 transition flex-1">Filter</button>
                    <a href="riwayat.php" class="bg-gray-100 text-gray-400 px-6 py-2.5 rounded-xl font-bold hover:bg-gray-200 transition text-center flex-1">Reset</a>
                </div>
            </form>
        </div>

        <div class="bg-white rounded-3xl shadow-xl overflow-hidden border border-gray-100">
            <div class="p-6 border-b flex justify-between items-center">
                <h2 class="text-xl font-bold text-gray-800">Riwayat Pembayaran</h2>
                <button onclick="window.print()" class="text-emerald-600 hover:bg-emerald-50 px-4 py-2 rounded-xl transition text-sm font-bold no-print">
                    <i class="fas fa-print mr-1"></i> Cetak
                </button>
            </div>
            
            <div class="overflow-x-auto">
                <table class="w-full text-left">
                    <thead>
                        <tr class="bg-gray-50 text-[10px] uppercase text-gray-400 font-bold border-b">
                            <th class="p-5">Tanggal</th>
                            <th class="p-5">Nama Siswa</th>
                            <th class="p-5">Periode</th>
                            <th class="p-5">Status</th>
                            <th class="p-5">Jumlah Bayar</th>
                            <th class="p-5 no-print">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="text-sm">
                        <?php
                        $sql = "SELECT pembayaran.*, siswa.nama_siswa FROM pembayaran JOIN siswa ON pembayaran.id_siswa = siswa.id";
                        if ($tgl_mulai != '' && $tgl_sampai != '') {
                            $sql .= " WHERE tgl_bayar BETWEEN '$tgl_mulai' AND '$tgl_sampai'";
                        }
                        $sql .= " ORDER BY tgl_bayar DESC";
                        $query = mysqli_query($conn, $sql);

                        while($r = mysqli_fetch_array($query)) { ?>
                            <tr class="border-b border-gray-50 hover:bg-emerald-50/30">
                                <td class="p-5 text-gray-500"><?php echo date('d/m/Y', strtotime($r['tgl_bayar'])); ?></td>
                                <td class="p-5 font-bold"><?php echo $r['nama_siswa']; ?></td>
                                <td class="p-5"><?php echo $r['periode']; ?></td>
                                <td class="p-5"><span class="bg-emerald-100 text-emerald-700 px-3 py-1 rounded-full text-[10px] font-bold uppercase">Lunas</span></td>
                                <td class="p-5 font-bold text-emerald-600">Rp <?php echo number_format($r['jumlah_bayar'], 0, ',', '.'); ?></td>
                                <td class="p-5 no-print flex gap-3">
                                    <a href="edit_pembayaran.php?id=<?php echo $r['id_pembayaran']; ?>" class="text-blue-500 hover:text-blue-700" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <a href="hapus_pembayaran.php?id=<?php echo $r['id_pembayaran']; ?>" class="text-red-500 hover:text-red-700" title="Hapus" onclick="return confirm('Hapus data ini?')">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>
</body>
</html>