<?php
session_start();
// Cek login
if (!isset($_SESSION['admin'])) {
    header("location:login.php");
    exit();
}

include 'koneksi.php';

// PROSES SIMPAN DATA
if (isset($_POST['simpan'])) {
    // Ambil data dari form
    $nis         = mysqli_real_escape_string($conn, $_POST['nis']);
    $nama_siswa  = mysqli_real_escape_string($conn, $_POST['nama_siswa']);
    $kelas       = mysqli_real_escape_string($conn, $_POST['kelas']);

    // Query INSERT ke tabel siswa
    $query = "INSERT INTO siswa (nis, nama_siswa, kelas) VALUES ('$nis', '$nama_siswa', '$kelas')";
    
    if (mysqli_query($conn, $query)) {
        // Jika berhasil, muncul alert dan pindah ke halaman index.php (Dashboard)
        echo "<script>alert('Data Siswa Berhasil Disimpan!'); window.location='index.php';</script>";
        exit();
    } else {
        // Tampilkan pesan jika ada error di database
        echo "<script>alert('Gagal Simpan: " . mysqli_error($conn) . "');</script>";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tambah Siswa - SPP Digital</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="bg-emerald-50 font-sans min-h-screen flex flex-col">

    <nav class="bg-emerald-600 p-4 text-white shadow-lg sticky top-0 z-50">
        <div class="container mx-auto flex justify-between items-center">
            <div class="flex items-center gap-3">
                <div class="bg-emerald-500 p-2 rounded-xl shadow-md border border-emerald-400/30">
                    <i class="fas fa-wallet text-white text-lg"></i>
                </div>
                <div>
                    <h1 class="text-lg font-bold leading-none text-white">SPP Digital</h1>
                    <span class="text-[10px] uppercase tracking-widest text-emerald-100 italic">Secure Management</span>
                </div>
            </div>
            <a href="index.php" class="text-xs bg-emerald-800 hover:bg-emerald-900 px-4 py-2 rounded-lg transition-all flex items-center gap-2 font-bold shadow-inner">
                <i class="fas fa-arrow-left"></i> Dashboard
            </a>
        </div>
    </nav>

    <main class="container mx-auto p-6 flex-grow flex items-center justify-center">
        <div class="bg-white w-full max-w-xl rounded-3xl shadow-2xl overflow-hidden border border-emerald-100">
            <div class="p-8 border-b border-emerald-50 bg-white">
                <div class="flex items-center gap-3 text-emerald-600 mb-2">
                    <div class="bg-emerald-100 p-3 rounded-full">
                        <i class="fas fa-user-plus text-xl"></i>
                    </div>
                    <h2 class="text-2xl font-black text-gray-800 tracking-tight">Tambah Siswa</h2>
                </div>
                <p class="text-gray-400 text-sm">Lengkapi formulir di bawah untuk mendaftarkan siswa baru.</p>
            </div>

            <form action="" method="POST" class="p-8 space-y-6">
                <div>
                    <label class="block text-xs font-bold text-emerald-700 uppercase tracking-widest mb-2 ml-1">Nomor Induk Siswa (NIS)</label>
                    <div class="relative group">
                        <i class="fas fa-id-card absolute left-4 top-4 text-emerald-300 group-focus-within:text-emerald-500 transition"></i>
                        <input type="text" name="nis" placeholder="Contoh: 2024001" required 
                               class="w-full border-2 border-gray-100 rounded-2xl pl-12 pr-4 py-3.5 focus:ring-4 focus:ring-emerald-50 focus:border-emerald-400 outline-none transition text-gray-700 font-medium">
                    </div>
                </div>

                <div>
                    <label class="block text-xs font-bold text-emerald-700 uppercase tracking-widest mb-2 ml-1">Nama Lengkap</label>
                    <div class="relative group">
                        <i class="fas fa-user absolute left-4 top-4 text-emerald-300 group-focus-within:text-emerald-500 transition"></i>
                        <input type="text" name="nama_siswa" placeholder="Masukkan nama lengkap siswa" required 
                               class="w-full border-2 border-gray-100 rounded-2xl pl-12 pr-4 py-3.5 focus:ring-4 focus:ring-emerald-50 focus:border-emerald-400 outline-none transition text-gray-700 font-medium">
                    </div>
                </div>

                <div>
                    <label class="block text-xs font-bold text-emerald-700 uppercase tracking-widest mb-2 ml-1">Kelas</label>
                    <div class="relative group">
                        <i class="fas fa-graduation-cap absolute left-4 top-4 text-emerald-300 group-focus-within:text-emerald-500 transition"></i>
                        <input type="text" name="kelas" placeholder="Contoh: XII RPL 1" required 
                               class="w-full border-2 border-gray-100 rounded-2xl pl-12 pr-4 py-3.5 focus:ring-4 focus:ring-emerald-50 focus:border-emerald-400 outline-none transition text-gray-700 font-medium">
                    </div>
                </div>

                <div class="pt-4 flex flex-col md:flex-row gap-4">
                    <button type="submit" name="simpan" class="bg-emerald-600 hover:bg-emerald-700 text-white flex-[2] py-4 rounded-2xl shadow-lg shadow-emerald-200 font-black text-sm uppercase tracking-widest flex items-center justify-center gap-3 transition-all transform active:scale-95">
                        <i class="fas fa-save text-lg"></i> Simpan Data
                    </button>
                    <button type="reset" class="bg-gray-100 text-gray-400 hover:bg-gray-200 flex-1 py-4 rounded-2xl font-bold text-sm transition uppercase tracking-widest">
                        Reset
                    </button>
                </div>
            </form>
        </div>
    </main>

    <footer class="text-center py-8 text-emerald-600/40 text-[10px] uppercase tracking-[0.2em] font-bold">
        &copy; 2025 SPP Digital System &bull; Emerald Edition
    </footer>

</body>
</html>