<?php
session_start();
include "../config/koneksi.php";

if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

// Ambil data wisata + kategori
$query = mysqli_query($koneksi, "
    SELECT wisata.*, kategori.nama_kategori 
    FROM wisata 
    LEFT JOIN kategori ON wisata.id_kategori = kategori.id_kategori
    ORDER BY id_wisata DESC
");
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Data Wisata | Admin</title>
    <link rel="stylesheet" href="style.css">
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }
        th, td {
            border: 1px solid #ccc;
            padding: 8px;
            text-align: left;
            vertical-align: top;
        }
        th {
            background: #0d6efd;
            color: #fff;
        }
        img {
            border-radius: 4px;
        }
        .aksi a {
            margin-right: 6px;
            text-decoration: none;
            color: #0d6efd;
        }
        .aksi a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>

<h2>Data Wisata</h2>
<a href="dashboard.php">← Dashboard</a> | 
<a href="tambah_wisata.php">+ Tambah Wisata</a>

<table>
    <tr>
        <th>No</th>
        <th>Nama Wisata</th>
        <th>Kategori</th>
        <th>Alamat</th>
        <th>Gambar</th>
        <th>Aksi</th>
    </tr>

    <?php
    $no = 1;
    while ($w = mysqli_fetch_assoc($query)) {
    ?>
    <tr>
        <td><?= $no++; ?></td>
        <td><?= $w['nama_wisata']; ?></td>
        <td><?= $w['nama_kategori']; ?></td>
        <td><?= $w['alamat']; ?></td>
        <td>
            <?php if (!empty($w['gambar'])) { ?>
                <img src="../img/<?= $w['gambar']; ?>" width="80">
            <?php } else { ?>
                <i>Tidak ada</i>
            <?php } ?>
        </td>
        <td class="aksi">
            <a href="edit_wisata.php?id=<?= $w['id_wisata']; ?>">Edit</a> |
            <a href="hapus_wisata.php?id=<?= $w['id_wisata']; ?>"
               onclick="return confirm('Yakin ingin menghapus data ini?')">
               Hapus
            </a>
        </td>
    </tr>
    <?php } ?>

</table>

</body>
</html>
