<?php
include __DIR__ . "/config/koneksi.php";

$wisata = mysqli_query($koneksi, "
    SELECT wisata.*, kategori.nama_kategori 
    FROM wisata 
    LEFT JOIN kategori ON wisata.id_kategori = kategori.id_kategori
    ORDER BY id_wisata DESC
");
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Wisata Kabupaten Asahan</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f5f5f5;
        }

        /* NAVBAR */
        .navbar {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 1rem 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: sticky;
            top: 0;
            z-index: 1000;
        }

        .navbar-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .nav-brand {
            font-size: 1.5rem;
            font-weight: bold;
            letter-spacing: 1px;
        }

        .nav-menu {
            display: flex;
            gap: 2rem;
        }

        .nav-menu a {
            color: white;
            text-decoration: none;
            transition: opacity 0.3s;
            font-weight: 500;
        }

        .nav-menu a:hover {
            opacity: 0.8;
        }

        /* HERO */
        .hero {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 5rem 20px;
            text-align: center;
        }

        .hero h1 {
            font-size: 2.5rem;
            margin-bottom: 1rem;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.2);
        }

        .hero p {
            max-width: 700px;
            margin: 0 auto;
            font-size: 1.1rem;
            line-height: 1.8;
            opacity: 0.95;
        }

        /* CONTAINER */
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 3rem 20px;
        }

        .container h2 {
            font-size: 2rem;
            margin-bottom: 0.5rem;
            color: #667eea;
        }

        .container > p {
            color: #666;
            margin-bottom: 2rem;
        }

        /* GRID */
        .grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(320px, 1fr));
            gap: 2rem;
            margin-top: 2rem;
        }

        /* CARD */
        .card {
            background: white;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
            transition: transform 0.3s, box-shadow 0.3s;
        }

        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 15px rgba(0,0,0,0.2);
        }

        .card img {
            width: 100%;
            height: 200px;
            object-fit: cover;
            display: block;
        }

        .card-content {
            padding: 1.25rem;
        }

        .card h4 {
            font-size: 1.25rem;
            margin-bottom: 0.5rem;
            color: #333;
        }

        .card small {
            display: inline-block;
            background: #667eea;
            color: white;
            padding: 0.25rem 0.75rem;
            border-radius: 20px;
            font-size: 0.75rem;
            margin-bottom: 0.75rem;
        }

        .card p {
            color: #666;
            line-height: 1.6;
            margin-top: 0.5rem;
            margin-bottom: 1rem;
        }

        /* MAPS CONTAINER */
        .maps-container {
            margin-top: 1rem;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }

        .maps-container iframe {
            width: 100%;
            height: 250px;
            border: none;
            display: block;
        }

        .location-badge {
            display: inline-flex;
            align-items: center;
            gap: 5px;
            background: #f0f0f0;
            color: #555;
            padding: 0.4rem 0.75rem;
            border-radius: 6px;
            font-size: 0.85rem;
            margin-top: 0.5rem;
        }

        .location-badge::before {
            content: "📍";
        }

        /* FOOTER */
        .footer {
            background: #2d3748;
            color: white;
            text-align: center;
            padding: 2rem 20px;
            margin-top: 3rem;
        }

        .footer p {
            opacity: 0.9;
        }

        /* RESPONSIVE */
        @media (max-width: 768px) {
            .navbar-container {
                flex-direction: column;
                gap: 1rem;
            }

            .nav-menu {
                flex-direction: column;
                gap: 0.5rem;
                text-align: center;
            }

            .hero h1 {
                font-size: 1.8rem;
            }

            .hero p {
                font-size: 1rem;
            }

            .grid {
                grid-template-columns: 1fr;
                gap: 1.5rem;
            }

            .container h2 {
                font-size: 1.5rem;
            }

            .maps-container iframe {
                height: 200px;
            }
        }

        @media (max-width: 480px) {
            .hero {
                padding: 3rem 20px;
            }

            .hero h1 {
                font-size: 1.5rem;
            }

            .container {
                padding: 2rem 15px;
            }
        }
    </style>
</head>
<body>

<!-- NAVBAR -->
<div class="navbar">
    <div class="navbar-container">
        <div class="nav-brand">Wisata Asahan</div>
        <div class="nav-menu">
            <a href="index.php">Beranda</a>
            <a href="#wisata">Wisata</a>
            <a href="kontak.php">Kontak</a>
            <a href="admin/login.php">Login Admin</a>
        </div>
    </div>
</div>

<!-- HERO / HEADER -->
<div class="hero">
    <h1>Selamat Datang di Kabupaten Asahan</h1>
    <p>
        Kabupaten Asahan merupakan salah satu daerah di Provinsi Sumatera Utara
        yang memiliki kekayaan alam, budaya, dan destinasi wisata menarik
        yang patut untuk dikunjungi.
    </p>
</div>

<!-- WISATA -->
<div class="container">
    <h2 id="wisata">Destinasi Wisata Asahan</h2>
    <p>Berikut beberapa tempat wisata yang dapat Anda kunjungi:</p>

    <div class="grid">
        <?php while ($w = mysqli_fetch_assoc($wisata)) { ?>
        <div class="card">
            <img src="img/<?= $w['gambar']; ?>" alt="<?= $w['nama_wisata']; ?>">
            <div class="card-content">
                <h4><?= $w['nama_wisata']; ?></h4>
                <small><?= $w['nama_kategori']; ?></small>
                <p><?= substr($w['deskripsi'], 0, 100); ?>...</p>
                
                <?php if (!empty($w['alamat'])) { ?>
                    <div class="location-badge">
                        <?= $w['alamat']; ?>
                    </div>
                <?php } ?>

                <?php if (!empty($w['maps'])) { ?>
                    <div class="maps-container">
                        <?= $w['maps']; ?>
                    </div>
                <?php } ?>
            </div>
        </div>
        <?php } ?>
    </div>
</div>

<!-- FOOTER -->
<div class="footer">
    <p>© <?= date('Y'); ?> Website Informasi Wisata Kabupaten Asahan</p>
</div>

</body>
</html>